/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.event.DocumentEvent;
import com.sun.java.swing.event.UndoableEditEvent;
import com.sun.java.swing.text.AbstractDocument;
import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.Segment;
import com.sun.java.swing.text.SimpleAttributeSet;
import com.sun.java.swing.text.StateInvariantError;
import com.sun.java.swing.text.StringContent;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.StyleContext;
import com.sun.java.swing.text.StyledDocument;
import com.sun.java.swing.undo.AbstractUndoableEdit;
import com.sun.java.swing.undo.CannotRedoException;
import com.sun.java.swing.undo.CannotUndoException;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;

public class DefaultStyledDocument
extends AbstractDocument
implements StyledDocument {
    public static final int BUFFER_SIZE_DEFAULT = 4096;
    private ElementBuffer buffer = new ElementBuffer(this.createDefaultRoot());

    public DefaultStyledDocument(AbstractDocument.Content content, StyleContext styleContext) {
        super(content, styleContext);
        Style style = styleContext.getStyle("default");
        this.setLogicalStyle(0, style);
    }

    public DefaultStyledDocument(StyleContext styleContext) {
        this((AbstractDocument.Content)new StringContent(4096), styleContext);
    }

    public DefaultStyledDocument() {
        this((AbstractDocument.Content)new StringContent(4096), new StyleContext());
    }

    public Element getDefaultRootElement() {
        return this.buffer.getRootElement();
    }

    protected void insert(int n, ElementSpec[] elementSpecArray) throws BadLocationException {
        try {
            this.writeLock();
            AbstractDocument.Content content = this.getContent();
            int n2 = elementSpecArray.length;
            int n3 = n;
            int n4 = 0;
            while (n4 < n2) {
                ElementSpec elementSpec = elementSpecArray[n4];
                if (elementSpec.getLength() > 0) {
                    content.insertString(n3, new String(elementSpec.getArray(), elementSpec.getOffset(), elementSpec.getLength()));
                    n3 += elementSpec.getLength();
                }
                ++n4;
            }
            int n5 = n3 - n;
            DefaultStyledDocument defaultStyledDocument = this;
            defaultStyledDocument.getClass();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = defaultStyledDocument.new AbstractDocument.DefaultDocumentEvent(n, n5, DocumentEvent.EventType.CHANGE);
            this.buffer.insert(n, n5, elementSpecArray, defaultDocumentEvent);
            defaultDocumentEvent.end();
            this.fireInsertUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        catch (Throwable throwable) {
            Object var4_11 = null;
            this.writeUnlock();
            throw throwable;
        }
        Object var4_10 = null;
        this.writeUnlock();
    }

    public Style addStyle(String string, Style style) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.addStyle(string, style);
    }

    public void removeStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        styleContext.removeStyle(string);
    }

    public Style getStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyle(string);
    }

    public void setLogicalStyle(int n, Style style) {
        Element element = this.getParagraphElement(n);
        if (element != null && element instanceof AbstractDocument.AbstractElement) {
            try {
                this.writeLock();
                StyleChangeUndoableEdit styleChangeUndoableEdit = new StyleChangeUndoableEdit((AbstractDocument.AbstractElement)element, style);
                ((AbstractDocument.AbstractElement)element).setResolveParent(style);
                int n2 = element.getStartOffset();
                int n3 = element.getEndOffset();
                DefaultStyledDocument defaultStyledDocument = this;
                defaultStyledDocument.getClass();
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = defaultStyledDocument.new AbstractDocument.DefaultDocumentEvent(n2, n3 - n2, DocumentEvent.EventType.CHANGE);
                defaultDocumentEvent.addEdit(styleChangeUndoableEdit);
                defaultDocumentEvent.end();
                this.fireChangedUpdate(defaultDocumentEvent);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
                return;
            }
            finally {
                Object var5_8 = null;
                this.writeUnlock();
            }
        }
    }

    public Style getLogicalStyle(int n) {
        Style style = null;
        Element element = this.getParagraphElement(n);
        if (element != null) {
            AttributeSet attributeSet = element.getAttributes();
            style = (Style)attributeSet.getResolveParent();
        }
        return style;
    }

    public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        try {
            this.writeLock();
            DefaultStyledDocument defaultStyledDocument = this;
            defaultStyledDocument.getClass();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = defaultStyledDocument.new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            this.buffer.change(n, n2, defaultDocumentEvent);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            int n3 = Integer.MAX_VALUE;
            int n4 = n;
            while (n4 < n + n2) {
                Element element = this.getCharacterElement(n4);
                n3 = element.getEndOffset();
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element, attributeSet2, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                n4 = n3;
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            this.writeUnlock();
            throw throwable;
        }
        Object var6_11 = null;
        this.writeUnlock();
    }

    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        try {
            this.writeLock();
            DefaultStyledDocument defaultStyledDocument = this;
            defaultStyledDocument.getClass();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = defaultStyledDocument.new AbstractDocument.DefaultDocumentEvent(n, n2, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            Element element = this.getDefaultRootElement();
            int n3 = element.getElementIndex(n);
            int n4 = element.getElementIndex(n + (n2 > 0 ? n2 - 1 : 0));
            int n5 = n3;
            while (n5 <= n4) {
                Element element2 = element.getElement(n5);
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element2, attributeSet2, bl));
                if (bl) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                ++n5;
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            this.writeUnlock();
            throw throwable;
        }
        Object var6_13 = null;
        this.writeUnlock();
    }

    public Element getParagraphElement(int n) {
        Element element = this.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        return element2;
    }

    public Element getCharacterElement(int n) {
        Element element = null;
        element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int n2 = element.getElementIndex(n);
            element = element.getElement(n2);
        }
        return element;
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        if (attributeSet == null) {
            attributeSet = SimpleAttributeSet.EMPTY;
        }
        Element element = this.getParagraphElement(n);
        Element element2 = element.getElement(element.getElementIndex(n));
        AttributeSet attributeSet2 = element.getAttributes();
        AttributeSet attributeSet3 = element2.getAttributes();
        try {
            Object[] objectArray;
            boolean bl = false;
            boolean bl2 = false;
            Segment segment = new Segment();
            Vector<ElementSpec> vector = new Vector<ElementSpec>();
            this.getText(n, n2, segment);
            char[] cArray = segment.array;
            int n3 = segment.offset + segment.count;
            int n4 = segment.offset;
            int n5 = segment.offset;
            while (n5 < n3) {
                if (cArray[n5] == '\n') {
                    int n6 = n5 + 1;
                    vector.addElement(new ElementSpec(attributeSet, 3, n6 - n4));
                    vector.addElement(new ElementSpec(null, 2));
                    vector.addElement(new ElementSpec(attributeSet2, 1));
                    n4 = n6;
                }
                ++n5;
            }
            if (n4 < n3) {
                vector.addElement(new ElementSpec(attributeSet, 3, n3 - n4));
            } else {
                bl2 = true;
            }
            if (n > 0) {
                this.getText(n - 1, 1, segment);
                if (segment.array[segment.offset] == '\n') {
                    bl = true;
                    ElementSpec elementSpec = new ElementSpec(attributeSet2, 1);
                    vector.insertElementAt(elementSpec, 0);
                    elementSpec = new ElementSpec(attributeSet2, 2);
                    vector.insertElementAt(elementSpec, 0);
                }
            }
            ElementSpec elementSpec = (ElementSpec)vector.firstElement();
            if (!bl && attributeSet3.isEqual(attributeSet) && n > 0) {
                elementSpec.setDirection((short)4);
            }
            if (!(vector.size() <= 1 && elementSpec.getDirection() == 4 || bl2)) {
                objectArray = (Object[])vector.lastElement();
                if (element2.getEndOffset() <= n + n2) {
                    attributeSet3 = this.getCharacterElement(n + n2).getAttributes();
                }
                if (attributeSet3.isEqual(attributeSet)) {
                    objectArray.setDirection((short)5);
                }
            }
            objectArray = new ElementSpec[vector.size()];
            vector.copyInto(objectArray);
            this.buffer.insert(n, n2, (ElementSpec[])objectArray, defaultDocumentEvent);
            return;
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        this.buffer.remove(defaultDocumentEvent.getOffset(), defaultDocumentEvent.getLength(), defaultDocumentEvent);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SectionElement sectionElement = new SectionElement();
        DefaultStyledDocument defaultStyledDocument = this;
        defaultStyledDocument.getClass();
        AbstractDocument.BranchElement branchElement = defaultStyledDocument.new AbstractDocument.BranchElement(sectionElement, null);
        DefaultStyledDocument defaultStyledDocument2 = this;
        defaultStyledDocument2.getClass();
        AbstractDocument.LeafElement leafElement = defaultStyledDocument2.new AbstractDocument.LeafElement(branchElement, null, 0, 1);
        Element[] elementArray = new Element[]{leafElement};
        branchElement.replace(0, 0, elementArray);
        elementArray[0] = branchElement;
        sectionElement.replace(0, 0, elementArray);
        this.writeUnlock();
        return sectionElement;
    }

    public Color getForeground(AttributeSet attributeSet) {
        return StyleConstants.getForeground(attributeSet);
    }

    public Color getBackground(AttributeSet attributeSet) {
        throw new Error("not implemented");
    }

    public Font getFont(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getFont(attributeSet);
    }

    protected class SectionElement
    extends AbstractDocument.BranchElement {
        public SectionElement() {
            super(null, null);
            DefaultStyledDocument.this = DefaultStyledDocument.this;
        }

        public String getName() {
            return "section";
        }
    }

    public static class ElementSpec {
        public static final short StartTagType = 1;
        public static final short EndTagType = 2;
        public static final short ContentType = 3;
        public static final short JoinPreviousDirection = 4;
        public static final short JoinNextDirection = 5;
        public static final short OriginateDirection = 6;
        private AttributeSet attr;
        private int len;
        private short type;
        private short direction;
        private int offs;
        private char[] data;

        public ElementSpec(AttributeSet attributeSet, short s) {
            this(attributeSet, s, null, 0, 0);
        }

        public ElementSpec(AttributeSet attributeSet, short s, int n) {
            this(attributeSet, s, null, 0, n);
        }

        public ElementSpec(AttributeSet attributeSet, short s, char[] cArray, int n, int n2) {
            this.attr = attributeSet;
            this.type = s;
            this.data = cArray;
            this.offs = n;
            this.len = n2;
            this.direction = (short)6;
        }

        public void setType(short s) {
            this.type = s;
        }

        public short getType() {
            return this.type;
        }

        public void setDirection(short s) {
            this.direction = s;
        }

        public short getDirection() {
            return this.direction;
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        public char[] getArray() {
            return this.data;
        }

        public int getOffset() {
            return 0;
        }

        public int getLength() {
            return this.len;
        }

        public String toString() {
            String string = "??";
            String string2 = "??";
            switch (this.type) {
                case 1: {
                    string = "StartTag";
                    break;
                }
                case 3: {
                    string = "Content";
                    break;
                }
                case 2: {
                    string = "EndTag";
                    break;
                }
            }
            switch (this.direction) {
                case 4: {
                    string2 = "JoinPrevious";
                    break;
                }
                case 5: {
                    string2 = "JoinNext";
                    break;
                }
                case 6: {
                    string2 = "Originate";
                    break;
                }
            }
            return String.valueOf(string) + ":" + string2 + ":" + this.getLength();
        }
    }

    public class ElementBuffer
    implements Serializable {
        Element root;
        transient int pos;
        transient int offset;
        transient int length;
        transient Vector endJoin;
        transient Vector changes;
        transient Stack path;
        transient boolean insertOp;

        public ElementBuffer(Element element) {
            DefaultStyledDocument.this = DefaultStyledDocument.this;
            this.root = element;
            this.changes = new Vector();
            this.path = new Stack();
            this.endJoin = new Vector();
        }

        public Element getRootElement() {
            return this.root;
        }

        public final void insert(int n, int n2, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.insertOp = true;
            this.beginEdits(n, n2);
            this.insertUpdate(elementSpecArray);
            this.endEdits(defaultDocumentEvent);
            this.insertOp = false;
        }

        public final void remove(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.beginEdits(n, n2);
            this.removeUpdate();
            this.endEdits(defaultDocumentEvent);
        }

        public final void change(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.beginEdits(n, n2);
            this.changeUpdate();
            this.endEdits(defaultDocumentEvent);
        }

        protected void insertUpdate(ElementSpec[] elementSpecArray) {
            Element element = this.root;
            int n = element.getElementIndex(this.offset);
            while (!element.isLeaf()) {
                Element element2 = element.getElement(n);
                this.push(element, element2.isLeaf() ? n : n + 1);
                element = element2;
                n = element.getElementIndex(this.offset);
            }
            this.open(elementSpecArray);
            int n2 = elementSpecArray.length;
            int n3 = 0;
            while (n3 < n2) {
                this.insertElement(elementSpecArray[n3]);
                ++n3;
            }
            this.close();
            while (this.path.size() != 0) {
                this.pop();
            }
        }

        protected void removeUpdate() {
            this.removeElements(this.root, this.offset, this.offset + this.length);
        }

        protected void changeUpdate() {
            boolean bl = this.split(this.offset, this.length);
            if (!bl) {
                while (this.path.size() != 0) {
                    this.pop();
                }
                this.split(this.offset + this.length, 0);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
        }

        boolean split(int n, int n2) {
            boolean bl = false;
            Element element = this.root;
            int n3 = element.getElementIndex(n);
            while (!element.isLeaf()) {
                this.push(element, n3);
                element = element.getElement(n3);
                n3 = element.getElementIndex(n);
            }
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            Element element2 = elemChanges.parent.getElement(elemChanges.index);
            if (element2.getStartOffset() != n) {
                int n4;
                int n5 = n4 = elemChanges.index;
                if (n + n2 < elemChanges.parent.getEndOffset() && n2 != 0) {
                    n5 = elemChanges.parent.getElementIndex(n + n2);
                    if (n5 == n4) {
                        elemChanges.removed.addElement(element2);
                        element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), n);
                        elemChanges.added.addElement(element);
                        element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), n, n + n2);
                        elemChanges.added.addElement(element);
                        element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), n + n2, element2.getEndOffset());
                        elemChanges.added.addElement(element);
                        return true;
                    }
                    element2 = elemChanges.parent.getElement(n5);
                    if (n + n2 == element2.getStartOffset()) {
                        n5 = n4;
                    }
                    bl = true;
                }
                this.pos = n;
                element2 = elemChanges.parent.getElement(n4);
                elemChanges.removed.addElement(element2);
                element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), this.pos);
                elemChanges.added.addElement(element);
                element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), this.pos, element2.getEndOffset());
                elemChanges.added.addElement(element);
                int n6 = n4 + 1;
                while (n6 < n5) {
                    element2 = elemChanges.parent.getElement(n6);
                    elemChanges.removed.addElement(element2);
                    elemChanges.added.addElement(element2);
                    ++n6;
                }
                if (n5 != n4) {
                    element2 = elemChanges.parent.getElement(n5);
                    this.pos = n + n2;
                    elemChanges.removed.addElement(element2);
                    element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), this.pos);
                    elemChanges.added.addElement(element);
                    element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element2.getAttributes(), this.pos, element2.getEndOffset());
                    elemChanges.added.addElement(element);
                }
            }
            return bl;
        }

        void endEdits(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            int n = this.changes.size();
            int n2 = 0;
            while (n2 < n) {
                ElemChanges elemChanges = (ElemChanges)this.changes.elementAt(n2);
                Object[] objectArray = new Element[elemChanges.removed.size()];
                elemChanges.removed.copyInto(objectArray);
                Object[] objectArray2 = new Element[elemChanges.added.size()];
                elemChanges.added.copyInto(objectArray2);
                int n3 = elemChanges.index;
                ((AbstractDocument.BranchElement)elemChanges.parent).replace(n3, objectArray.length, (Element[])objectArray2);
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit((AbstractDocument.BranchElement)elemChanges.parent, n3, (Element[])objectArray, (Element[])objectArray2);
                defaultDocumentEvent.addEdit(elementEdit);
                ++n2;
            }
        }

        void beginEdits(int n, int n2) {
            this.offset = n;
            this.length = n2;
            this.pos = n;
            if (this.changes == null) {
                this.changes = new Vector();
            } else {
                this.changes.removeAllElements();
            }
            if (this.path == null) {
                this.path = new Stack();
            } else {
                this.path.removeAllElements();
            }
            if (this.endJoin == null) {
                this.endJoin = new Vector();
                return;
            }
            this.endJoin.removeAllElements();
        }

        void push(Element element, int n) {
            ElemChanges cfr_ignored_0 = this.path.size() != 0 ? this.path.peek() : null;
            ElemChanges elemChanges = new ElemChanges(element, n);
            this.path.push(elemChanges);
        }

        void pop() {
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            this.path.pop();
            if (elemChanges.added.size() > 0 || elemChanges.removed.size() > 0) {
                this.changes.addElement(elemChanges);
                return;
            }
            if (!this.path.isEmpty()) {
                Element element = elemChanges.parent;
                elemChanges = (ElemChanges)this.path.peek();
                elemChanges.added.removeElement(element);
            }
        }

        void advance(int n) {
            this.pos += n;
        }

        void insertElement(ElementSpec elementSpec) {
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            switch (elementSpec.getType()) {
                case 1: {
                    Element element = DefaultStyledDocument.this.createBranchElement(elemChanges.parent, elementSpec.getAttributes());
                    elemChanges.added.addElement(element);
                    this.push(element, 0);
                    return;
                }
                case 2: {
                    this.pop();
                    return;
                }
                case 3: {
                    int n = elementSpec.getLength();
                    if (elementSpec.getDirection() != 4) {
                        Element element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, elementSpec.getAttributes(), this.pos, this.pos + n);
                        elemChanges.added.addElement(element);
                    }
                    this.pos += n;
                    return;
                }
            }
        }

        void removeElements(Element element, int n, int n2) {
            if (!element.isLeaf()) {
                int n3 = element.getElementIndex(n);
                int n4 = element.getElementIndex(n2);
                this.push(element, n3);
                if (n3 == n4) {
                    this.removeElements(element.getElement(n3), n, n2);
                } else {
                    Element element2 = element.getElement(n3);
                    Element element3 = element.getElement(n4);
                    ElemChanges elemChanges = (ElemChanges)this.path.peek();
                    if (this.canJoin(element2, element3)) {
                        int n5 = n3;
                        while (n5 <= n4) {
                            elemChanges.removed.addElement(element.getElement(n5));
                            ++n5;
                        }
                        Element element4 = this.join(element, element2, element3, n, n2);
                        elemChanges.added.addElement(element4);
                    } else {
                        int n6 = n3 + 1;
                        int n7 = n4 - 1;
                        if (element2.getStartOffset() == n) {
                            element2 = null;
                            n6 = n3;
                        }
                        if (element3.getStartOffset() == n2) {
                            element3 = null;
                        }
                        if (n6 <= n7) {
                            elemChanges.index = n6;
                        }
                        int n8 = n6;
                        while (n8 <= n7) {
                            elemChanges.removed.addElement(element.getElement(n8));
                            ++n8;
                        }
                        if (element2 != null) {
                            this.removeElements(element2, n, n2);
                        }
                        if (element3 != null) {
                            this.removeElements(element3, n, n2);
                        }
                    }
                }
                this.pop();
            }
        }

        boolean canJoin(Element element, Element element2) {
            if (element == null || element2 == null) {
                return false;
            }
            if (element.getName().equals("paragraph") && element2.getName().equals("paragraph")) {
                return true;
            }
            return element.getAttributes().isEqual(element2.getAttributes());
        }

        Element join(Element element, Element element2, Element element3, int n, int n2) {
            if (element2.isLeaf() && element3.isLeaf()) {
                return DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element3.getEndOffset());
            }
            if (!element2.isLeaf() && !element3.isLeaf()) {
                Element element4;
                Element element5 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
                int n3 = element2.getElementIndex(n);
                int n4 = element3.getElementIndex(n2);
                Element element6 = element2.getElement(n3);
                if (element6.getStartOffset() == n) {
                    element6 = null;
                }
                if ((element4 = element3.getElement(n4)).getStartOffset() == n2) {
                    element4 = null;
                }
                Vector<Element> vector = new Vector<Element>();
                int n5 = 0;
                while (n5 < n3) {
                    vector.addElement(this.clone(element5, element2.getElement(n5)));
                    ++n5;
                }
                if (this.canJoin(element6, element4)) {
                    Element element7 = this.join(element5, element6, element4, n, n2);
                    vector.addElement(element7);
                } else {
                    if (element6 != null) {
                        vector.addElement(this.clone(element5, element6));
                    }
                    if (element4 != null) {
                        vector.addElement(this.clone(element5, element4));
                    }
                }
                int n6 = element3.getElementCount();
                int n7 = element4 == null ? n4 : n4 + 1;
                while (n7 < n6) {
                    vector.addElement(this.clone(element5, element3.getElement(n7)));
                    ++n7;
                }
                Object[] objectArray = new Element[vector.size()];
                vector.copyInto(objectArray);
                ((AbstractDocument.BranchElement)element5).replace(0, 0, (Element[])objectArray);
                return element5;
            }
            throw new StateInvariantError("No support to join leaf element with non-leaf element");
        }

        public Element clone(Element element, Element element2) {
            if (element2.isLeaf()) {
                return DefaultStyledDocument.this.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
            }
            Element element3 = DefaultStyledDocument.this.createBranchElement(element, element2.getAttributes());
            int n = element2.getElementCount();
            Element[] elementArray = new Element[n];
            int n2 = 0;
            while (n2 < n) {
                elementArray[n2] = this.clone(element3, element2.getElement(n2));
                ++n2;
            }
            ((AbstractDocument.BranchElement)element3).replace(0, 0, elementArray);
            return element3;
        }

        void open(ElementSpec[] elementSpecArray) {
            int n = elementSpecArray[0].getDirection() == 4 ? this.offset + elementSpecArray[0].getLength() : this.offset;
            int n2 = this.offset + this.length;
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            Element element = elemChanges.parent.getElement(elemChanges.index);
            boolean bl = false;
            int n3 = 0;
            while (n3 < elementSpecArray.length) {
                if (elementSpecArray[n3].getType() == 2) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (bl || n != n2) {
                int n4;
                Element element2;
                elemChanges.removed.addElement(element);
                if (n != element.getStartOffset()) {
                    element2 = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), n);
                    elemChanges.added.addElement(element2);
                }
                if (element.getEndOffset() > n2) {
                    int n5 = element.getEndOffset() - n2;
                    ElementSpec elementSpec = new ElementSpec(element.getAttributes(), 3, n5);
                    this.endJoin.addElement(elementSpec);
                }
                if (bl) {
                    int n6 = elemChanges.parent.getElementCount();
                    int n7 = elemChanges.index + 1;
                    while (n7 < n6) {
                        element = elemChanges.parent.getElement(n7);
                        elemChanges.removed.addElement(element);
                        n4 = element.getEndOffset() - element.getStartOffset();
                        ElementSpec elementSpec = new ElementSpec(element.getAttributes(), 3, n4);
                        this.endJoin.addElement(elementSpec);
                        ++n7;
                    }
                }
                if (bl && this.endJoin.size() == 0) {
                    elemChanges = (ElemChanges)this.path.elementAt(this.path.size() - 2);
                    element2 = elemChanges.parent.getElement(elemChanges.index);
                    if (element2 != null) {
                        elemChanges.removed.addElement(element2);
                        int n8 = element2.getElementCount();
                        n4 = 0;
                        while (n4 < n8) {
                            element = element2.getElement(n4);
                            int n9 = element.getEndOffset() - element.getStartOffset();
                            ElementSpec elementSpec = new ElementSpec(element.getAttributes(), 3, n9);
                            this.endJoin.addElement(elementSpec);
                            ++n4;
                        }
                    }
                }
            }
        }

        void close() {
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            int n = this.endJoin.size();
            int n2 = 0;
            while (n2 < n) {
                ElementSpec elementSpec = (ElementSpec)this.endJoin.elementAt(n2);
                int n3 = this.pos + elementSpec.getLength();
                Element element = DefaultStyledDocument.this.createLeafElement(elemChanges.parent, elementSpec.getAttributes(), this.pos, n3);
                elemChanges.added.addElement(element);
                this.pos = n3;
                ++n2;
            }
        }

        class ElemChanges {
            Element parent;
            int index;
            Vector added;
            Vector removed;

            ElemChanges(Element element, int n) {
                ElementBuffer.this = ElementBuffer.this;
                this.parent = element;
                this.index = n;
                this.added = new Vector();
                this.removed = new Vector();
            }

            public String toString() {
                return "added: " + this.added + "\nremoved: " + this.removed + "\n";
            }
        }
    }

    static class AttributeUndoableEdit
    extends AbstractUndoableEdit {
        protected AttributeSet newAttributes;
        protected AttributeSet copy;
        protected boolean isReplacing;
        protected Element element;

        AttributeUndoableEdit(Element element, AttributeSet attributeSet, boolean bl) {
            this.element = element;
            this.newAttributes = attributeSet;
            this.isReplacing = bl;
            this.copy = element.getAttributes().copyAttributes();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.element.getAttributes();
            if (this.isReplacing) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(this.newAttributes);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.element.getAttributes();
            mutableAttributeSet.removeAttributes(this.newAttributes);
            mutableAttributeSet.addAttributes(this.copy);
        }
    }

    static class StyleChangeUndoableEdit
    extends AbstractUndoableEdit {
        protected AbstractDocument.AbstractElement element;
        protected Style newStyle;
        protected AttributeSet oldStyle;

        public StyleChangeUndoableEdit(AbstractDocument.AbstractElement abstractElement, Style style) {
            this.element = abstractElement;
            this.newStyle = style;
            this.oldStyle = abstractElement.getResolveParent();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.element.setResolveParent(this.newStyle);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.element.setResolveParent(this.oldStyle);
        }
    }
}

